/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import lotr.common.LOTRConfig;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.entity.LOTREntities;
import lotr.common.entity.LOTRMountFunctions;
import lotr.common.entity.animal.LOTREntityHorse;
import lotr.common.entity.npc.LOTRBannerBearer;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.entity.npc.LOTREntityWarg;
import lotr.common.entity.npc.LOTRHireableBase;
import lotr.common.entity.npc.LOTRHiredNPCInfo;
import lotr.common.entity.npc.LOTRNPCMount;
import lotr.common.entity.npc.NPCWeight;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRItemCoin;
import lotr.common.network.LOTRPacketHandler;
import lotr.common.network.PacketSyncNPCCount;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class LOTRUnitTradeEntry {
    public Class entityClass;
    public Class mountClass;
    private Item mountArmor;
    private float mountArmorChance;
    private String name;
    private int initialCost;
    public float alignmentRequired;
    private PledgeType pledgeType = PledgeType.NONE;
    public LOTRHiredNPCInfo.Task task = LOTRHiredNPCInfo.Task.WARRIOR;
    private String extraInfo = null;
    private static final int BASE_MAX_HIRED_NPCS = LOTRConfig.maxHiredNPCs;
    private static final int ADDITIONAL_NPCS_PER_1000_REP = LOTRConfig.NPCLVLUP;

    public LOTRUnitTradeEntry(Class c, int cost, float alignment) {
        this.entityClass = c;
        this.initialCost = cost;
        this.alignmentRequired = alignment;
        if (LOTRBannerBearer.class.isAssignableFrom(this.entityClass)) {
            this.setExtraInfo("Banner");
        }
    }

    public LOTRUnitTradeEntry(Class c, Class c1, String s, int cost, float alignment) {
        this(c, cost, alignment);
        this.mountClass = c1;
        this.name = s;
    }

    public LOTRUnitTradeEntry setTask(LOTRHiredNPCInfo.Task t) {
        this.task = t;
        return this;
    }

    public LOTRUnitTradeEntry setMountArmor(Item item) {
        return this.setMountArmor(item, 1.0f);
    }

    public LOTRUnitTradeEntry setMountArmor(Item item, float chance) {
        this.mountArmor = item;
        this.mountArmorChance = chance;
        return this;
    }

    public LOTRUnitTradeEntry setPledgeExclusive() {
        return this.setPledgeType(PledgeType.FACTION);
    }

    public LOTRUnitTradeEntry setPledgeType(PledgeType t) {
        this.pledgeType = t;
        return this;
    }

    public PledgeType getPledgeType() {
        return this.pledgeType;
    }

    public LOTRUnitTradeEntry setExtraInfo(String s) {
        this.extraInfo = s;
        return this;
    }

    public boolean hasExtraInfo() {
        return this.extraInfo != null;
    }

    public String getFormattedExtraInfo() {
        return StatCollector.func_74838_a((String)("lotr.unitinfo." + this.extraInfo));
    }

    public float costFromConfig() {
        return this.initialCost * LOTRConfig.maxHornCost;
    }

    public int getCost(EntityPlayer entityplayer, LOTRHireableBase trader) {
        float f;
        float cost = this.costFromConfig();
        float maxDiscount = 0.5f;
        float notPledgedExpense = 2.0f;
        LOTRFaction fac = trader.getFaction();
        LOTRPlayerData pd = LOTRLevelData.getData(entityplayer);
        float alignment = pd.getAlignment(fac);
        boolean pledged = pd.isPledgedTo(fac);
        float alignSurplus = Math.max(alignment - this.alignmentRequired, 0.0f);
        if (pledged) {
            f = alignSurplus / 4500.0f;
            f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
            cost *= 1.0f - (f *= 0.5f);
        } else {
            cost *= 2.0f;
            f = alignSurplus / 6000.0f;
            f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
            cost *= 1.0f - (f *= 0.5f);
        }
        int costI = Math.round(cost);
        costI = Math.max(costI, 1);
        this.updateItemMetadata(new ItemStack(LOTRMod.silverCoin), costI);
        return costI;
    }

    private int getMetaIndexForCost(int cost) {
        if (cost < 10) {
            return 0;
        }
        if (cost < 100) {
            return 1;
        }
        if (cost < 1000) {
            return 2;
        }
        if (cost < 10000) {
            return 3;
        }
        if (cost < 100000) {
            return 4;
        }
        if (cost < 1000000) {
            return 5;
        }
        return 6;
    }

    public boolean hasRequiredCostAndAlignment(EntityPlayer entityplayer, LOTRHireableBase trader) {
        int cost = this.getCost(entityplayer, trader);
        int coins = LOTRItemCoin.getInventoryValue(entityplayer, false);
        if (coins < cost) {
            return false;
        }
        LOTRFaction fac = trader.getFaction();
        if (!this.pledgeType.canAcceptPlayer(entityplayer, fac)) {
            return false;
        }
        float alignment = LOTRLevelData.getData(entityplayer).getAlignment(fac);
        if (alignment < this.alignmentRequired) {
            return false;
        }
        ItemStack coinStack = new ItemStack(LOTRMod.silverCoin);
        this.updateItemMetadata(coinStack, cost);
        return true;
    }

    public String getUnitTradeName() {
        if (this.mountClass == null) {
            String entityName = LOTREntities.getStringFromClass(this.entityClass);
            return StatCollector.func_74838_a((String)("entity." + entityName + ".name"));
        }
        return StatCollector.func_74838_a((String)("lotr.unit." + this.name));
    }

    public String getUnitTradeCodeName() {
        String codeName = this.entityClass.getSimpleName();
        if (codeName.startsWith("LOTREntity")) {
            codeName = codeName.substring("LOTREntity".length());
        }
        return codeName;
    }

    public void hireUnit(EntityPlayer entityplayer, LOTRHireableBase trader, String squadron) {
        LOTRPlayerData playerData = LOTRLevelData.getData(entityplayer);
        int maxHiredNPCs = playerData.getMaxHiredNPCs(entityplayer, trader.getFaction());
        int hiredNPCCount = playerData.getGlobalHiredNPCCount();
        if (hiredNPCCount >= maxHiredNPCs) {
            entityplayer.func_145747_a((IChatComponent)new ChatComponentTranslation("message.hireUnit.limitReached", new Object[]{maxHiredNPCs}));
            return;
        }
        int cost = this.getCost(entityplayer, trader);
        if (this.hasRequiredCostAndAlignment(entityplayer, trader)) {
            trader.onUnitTrade(entityplayer);
            LOTRItemCoin.takeCoins(cost, entityplayer);
            ((LOTREntityNPC)((Object)trader)).playTradeSound();
            World world = entityplayer.field_70170_p;
            LOTREntityNPC hiredNPC = this.getOrCreateHiredNPC(world);
            if (hiredNPC != null) {
                boolean unitExists = world.field_72996_f.contains(hiredNPC);
                EntityLiving mount = null;
                if (this.mountClass != null) {
                    mount = this.createHiredMount(world);
                }
                if (this.mountClass != null && mount == null) {
                    System.err.println("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd: mountClass \ufffd\ufffd\ufffd\ufffd\ufffd, \ufffd\ufffd createHiredMount(world) \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd null!");
                }
                hiredNPC.hiredNPCInfo.hireUnit(entityplayer, !unitExists, trader.getFaction(), this, squadron, (Entity)mount);
                if (!unitExists) {
                    world.func_72838_d((Entity)hiredNPC);
                }
                if (mount != null) {
                    world.func_72838_d((Entity)mount);
                    System.out.println("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd mount: " + mount.getClass().getSimpleName());
                    mount.func_70012_b(hiredNPC.field_70165_t, hiredNPC.field_70121_D.field_72338_b, hiredNPC.field_70161_v, hiredNPC.field_70177_z, 0.0f);
                    hiredNPC.func_70078_a((Entity)mount);
                    if (mount instanceof LOTRNPCMount && !(mount instanceof LOTREntityNPC)) {
                        hiredNPC.setRidingHorse(true);
                        LOTRNPCMount hiredHorse = (LOTRNPCMount)mount;
                        hiredHorse.setBelongsToNPC(true);
                        LOTRMountFunctions.setNavigatorRangeFromNPC(hiredHorse, hiredNPC);
                    }
                    if (mount instanceof LOTREntityNPC) {
                        ((LOTREntityNPC)mount).hiredNPCInfo.hireUnit(entityplayer, false, trader.getFaction(), this, squadron, null);
                    }
                }
                String entityName = hiredNPC.getClass().getSimpleName();
                int npcWeight = NPCWeight.getWeightByName(entityName);
                playerData.updateGlobalHiredNPCCount(npcWeight);
                PacketSyncNPCCount packet = new PacketSyncNPCCount(hiredNPCCount += npcWeight, maxHiredNPCs);
                LOTRPacketHandler.networkWrapper.sendTo((IMessage)packet, (EntityPlayerMP)entityplayer);
                String message = StatCollector.func_74837_a((String)"message.hired_npcs", (Object[])new Object[]{hiredNPCCount, maxHiredNPCs});
                entityplayer.func_145747_a((IChatComponent)new ChatComponentText(message));
            }
        }
    }

    private void updateItemMetadata(ItemStack itemStack, int cost) {
        int metaIndex = this.getMetaIndexForCost(cost);
        itemStack.func_77964_b(metaIndex);
    }

    public LOTREntityNPC getOrCreateHiredNPC(World world) {
        LOTREntityNPC entity = (LOTREntityNPC)EntityList.func_75620_a((String)LOTREntities.getStringFromClass(this.entityClass), (World)world);
        entity.initCreatureForHire(null);
        entity.refreshCurrentAttackMode();
        return entity;
    }

    public EntityLiving createHiredMount(World world) {
        if (this.mountClass == null) {
            return null;
        }
        EntityLiving entity = (EntityLiving)EntityList.func_75620_a((String)LOTREntities.getStringFromClass(this.mountClass), (World)world);
        if (entity instanceof LOTREntityNPC) {
            ((LOTREntityNPC)entity).initCreatureForHire(null);
            ((LOTREntityNPC)entity).refreshCurrentAttackMode();
        } else {
            entity.func_110161_a(null);
        }
        if (this.mountArmor != null && world.field_73012_v.nextFloat() < this.mountArmorChance) {
            if (entity instanceof LOTREntityHorse) {
                ((LOTREntityHorse)entity).setMountArmor(new ItemStack(this.mountArmor));
            } else if (entity instanceof LOTREntityWarg) {
                ((LOTREntityWarg)entity).setWargArmor(new ItemStack(this.mountArmor));
            }
        }
        return entity;
    }

    public static enum PledgeType {
        NONE(0),
        FACTION(1),
        ANY_ELF(2),
        ANY_DWARF(3);

        public final int typeID;

        private PledgeType(int i) {
            this.typeID = i;
        }

        public boolean canAcceptPlayer(EntityPlayer entityplayer, LOTRFaction fac) {
            LOTRPlayerData pd = LOTRLevelData.getData(entityplayer);
            LOTRFaction pledged = pd.getPledgeFaction();
            if (this == NONE) {
                return true;
            }
            if (this == FACTION) {
                return pd.isPledgedTo(fac);
            }
            if (this == ANY_ELF) {
                return pledged != null && pledged.isOfType(LOTRFaction.FactionType.TYPE_ELF) && !pledged.isOfType(LOTRFaction.FactionType.TYPE_MAN);
            }
            if (this == ANY_DWARF) {
                return pledged != null && pledged.isOfType(LOTRFaction.FactionType.TYPE_DWARF);
            }
            return false;
        }

        public String getCommandReqText(LOTRFaction fac) {
            if (this == NONE) {
                return null;
            }
            return StatCollector.func_74837_a((String)("lotr.hiredNPC.commandReq.pledge." + this.name()), (Object[])new Object[]{fac.factionName()});
        }

        public static PledgeType forID(int i) {
            for (PledgeType t : PledgeType.values()) {
                if (t.typeID != i) continue;
                return t;
            }
            return NONE;
        }
    }
}

